﻿IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IS_sp_UpdateOrCreateRespondent]') AND type in (N'P', N'	PC'))
DROP PROCEDURE [dbo].[IS_sp_UpdateOrCreateRespondent]
GO
CREATE  PROCEDURE [dbo].[IS_sp_UpdateOrCreateRespondent]
@ProjectId int,
@UserId int,
@CollectMode int,
@ResRespondent varchar(10),
@ResLanguage int,
@ResTimeZone int,
@ResCallbackDate datetime,
@Resphone nvarchar(20),
@ResLastCallDate datetime,
@ResCompleted bit,
@ResCodeResult varchar(2),
@ResPin varchar(100),
@ResLastCompQuest int,
@ResActive bit,
@LastA4SHistoricEntryDate datetime
AS
BEGIN
	DECLARE @previousLastCallDate datetime
	SELECT @previousLastCallDate = ResLastCallDate FROM Respondent WHERE ResRespondent = @ResRespondent

	UPDATE Respondent SET
		ProjectId = @ProjectId,
		CollectMode = @CollectMode,
		ModifiedBy = @UserId,
		Modified = GETUTCDATE(),
		ResLanguage = @ResLanguage,
		ResTimeZone = @ResTimeZone,
		ResLastCallDate = @ResLastCallDate,
		ResCompleted = @ResCompleted,
		ResLastCompQuest = @ResLastCompQuest,
		ResActive = @ResActive
	WHERE ResRespondent = @ResRespondent
	
	IF @@ROWCOUNT = 0
	BEGIN
		INSERT INTO respondent (ResRespondent, ProjectId, CollectMode, ModifiedBy, Modified, ResLanguage, ResTimeZone, ResCallbackDate,
								ResLastCallDate,ResCompleted, ResSeed, ResCodeResult, ResLastCompQuest, ResActive,
								ResIntervCall, ResCallCount, ResVersion, ResPriority, ResConfidPhone, ResWaveNo, ResBlocked, ResCompPredictive,
								ResCall, ResMonitored, ResPreviousCallDate, ResWaveImportNo, panelistId, ResNextIntervCall,Resphone)
		VALUES (@ResRespondent, @ProjectId, @CollectMode, @UserId, GETUTCDATE(), @ResLanguage, @ResTimeZone, isnull(@ResCallbackDate,0),
				@ResLastCallDate, @ResCompleted, CAST(@ResRespondent AS FLOAT), @ResCodeResult, @ResLastCompQuest, @ResActive,
				'', 0, '', 0, 0, 0, 0, 0,
				0, 0, 0, 0, 0, '',isnull(@Resphone,''))		
	END

	IF @Resphone is not null
		UPDATE Respondent SET Resphone=@Resphone WHERE ResRespondent=@ResRespondent

	IF @ResCallbackDate is not null
		UPDATE Respondent SET ResCallbackDate=@ResCallbackDate WHERE ResRespondent=@ResRespondent

	IF @ResCodeResult is not null AND LEN(@ResCodeResult) > 0 AND @previousLastCallDate is not null AND @previousLastCallDate < @LastA4SHistoricEntryDate
		UPDATE Respondent SET ResCodeResult=@ResCodeResult WHERE ResRespondent=@ResRespondent

	IF @ResPin is null or @ResPin = ''
		DELETE FROM RespondentPin WHERE rspRespondent=@ResRespondent
	ELSE
	BEGIN
		UPDATE RespondentPin SET rspPin=@ResPin, ProjectId = @ProjectId, ModifiedBy = @UserId, Modified = GETUTCDATE()
		WHERE rspRespondent=@ResRespondent
		
		IF @@rowcount = 0
			INSERT into RespondentPin values(@resRespondent,@resPin,@projectId,@userId,GETUTCDATE())
	END
END
GO                      







